<?php
//add files css & js
function file_css_js(){
    //CSS
    wp_enqueue_style('bootstrap-css', get_template_directory_uri() . "/css/bootstrap.min.css", array(), null);
    wp_enqueue_style('font-awesome-5all-css', get_template_directory_uri() . "/css/font-awesome.min.css", array(), null);
    wp_enqueue_style('owl-carousel-css', get_template_directory_uri() . "/css/owl.carousel.min.css", array(), null);
    wp_enqueue_style('animate-css', get_template_directory_uri() . "/css/animate.css", array(),null);
    wp_enqueue_style('fancy-css', get_template_directory_uri() . "/plugins/fancy-box/jquery.fancybox.min.css", array(),null);

    wp_enqueue_style('main-css', get_template_directory_uri() . "/css/style.css", array(),null);

    //JS
    wp_enqueue_script('jquery-js', get_template_directory_uri() . "/js/jquery-3.2.1.min.js", array(), null, true);
    wp_enqueue_script('popper-js', get_template_directory_uri() . "/js/popper.min.js", array(), null, true);
    wp_enqueue_script('bootstrap-js', get_template_directory_uri() . "/js/bootstrap.min.js", array(), null, true);
    wp_enqueue_script('plugins-js', get_template_directory_uri() . "/plugins/fancy-box/jquery.fancybox.min.js", array(), null, true);

    wp_enqueue_script('carousel-js', get_template_directory_uri() . "/js/owl.carousel.min.js", array(), null, true);
    wp_enqueue_script('wow-js', get_template_directory_uri() . "/js/wow.min.js", array(), null, true);


    wp_enqueue_script('main-js', get_template_directory_uri() . "/js/main.js", array(), null, true);
}

add_action('wp_enqueue_scripts', 'file_css_js');
//menu




add_theme_support( 'post-thumbnails' );
add_theme_support( 'title-tag' );
//Option Page
function option_page(){
    $option = array(
        'page_title' => 'اعدادات الموقع',
        'menu_title'    => __('اعدادات الموقع'),
        'menu_slug'     => 'general-settings',
        'capability'    => 'edit_posts',
        'redirect'      => false
    );
    acf_add_options_page($option);
}
add_action('acf/init', 'option_page');




function register_menus(){
    register_nav_menus(array(
        'header' => 'header',
        'footer' => 'footer',
      


    ));
}
add_action('after_setup_theme' , 'register_menus', 0 );





function services(){
    $values = array(
        'public' => true ,
        'labels' => array ('name' => 'services') ,
        'menu_icon' => 'dashicons-carrot',
        'supports' => array( 'title', 'editor', 'thumbnail' )
    );
    register_post_type('services' , $values);
}
add_action('init' , 'services' );




function products(){
    $values = array(
        'public' => true ,
        'labels' => array ('name' => 'المنتجات ') ,
        'menu_icon' => 'dashicons-carrot',
        'supports' => array( 'title', 'editor', 'thumbnail' )
    );
    register_post_type('products' , $values);
}
add_action('init' , 'products' );



//hook into the init action and call create_book_taxonomies when it fires
add_action( 'init', 'create_topics_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it topics for your posts

function create_topics_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like categories
//first do the translations part for GUI

    $labels = array(
        'name' => _x( 'الاقسام', 'taxonomy general name' ),
        'singular_name' => _x( 'category', 'taxonomy singular name' ),
    );

// Now register the taxonomy

    register_taxonomy('categorys',array('products'), array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
    ));
}


function dynamic_field_values ( $tag, $unused ) {

    if ( $tag['name'] != 'courses-posts' )
        return $tag;

    $args = array (
        'numberposts'   => -1,
        'post_type'     => 'services',
        'orderby'       => 'title',
        'order'         => 'ASC',
    );

    $custom_posts = get_posts($args);

    if ( ! $custom_posts )
        return $tag;

    foreach ( $custom_posts as $custom_post ) {

        $tag['raw_values'][] = $custom_post->post_title;
        $tag['values'][] = $custom_post->post_title;
        $tag['labels'][] = $custom_post->post_title;

    }

    return $tag;

}

add_filter( 'wpcf7_form_tag', 'dynamic_field_values', 10, 2);





//In function.php add this codes

add_filter( 'auto_update_plugin', '__return_true' );
add_filter( 'auto_update_theme', '__return_true' );